package gov.va.med.mhv.bluebutton.bbmi;

import gov.va.med.mhv.bluebutton.transfer.BbmiEventMessage;
import gov.va.med.mhv.common.api.cache.CacheHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class BbmiMdbSender {
	
	private static final Log LOG = LogFactory.getLog(BbmiMdbSender.class);
	
	private static final String API_TOKEN = "Token";

	private JmsTemplate jmsTemplate;

	public void sendMessage(final BbmiEventMessage bbmiEventMsg) {

		MessageCreator messageCreator = new MessageCreator() {
			public Message createMessage(Session session) throws JMSException {

				ObjectMessage objMsg = session.createObjectMessage(bbmiEventMsg);
				
				// This token is needed by the receiver of this message if any 
				// futher downstream APIs will be invoked.
				
				objMsg.setStringProperty(API_TOKEN, CacheHandler.getInstance().getToken());
				
				if(LOG.isDebugEnabled()) {
					LOG.debug(String.format("%s:%s", API_TOKEN, objMsg.getStringProperty(API_TOKEN)));
				}

				return objMsg;
			}

		};

		jmsTemplate.send("jms/bbmi/BBMI_IMAGE_Q", messageCreator);
	}

	public void setJmsTemplate(JmsTemplate jmsTemplate) {
		this.jmsTemplate = jmsTemplate;
	}

}
